function PlayerStandard:_start_action_running(t)
	if not self._move_dir then
		self._running_wanted = true
		return
	end
	if self:on_ladder() or self:_on_zipline() then
		return
	end
	if self._shooting and not self._equipped_unit:base():run_and_shoot_allowed() or self:_changing_weapon() or self:_is_meleeing() or self._use_item_expire_t or self._state_data.in_air or self:_is_throwing_projectile() or self:_is_charging_weapon() then
		self._running_wanted = true
		return
	end
	if self._state_data.ducking and not self:_can_stand() then
		self._running_wanted = true
		return
	end
	if not self:_can_run_directional() then
		return
	end
	self._running_wanted = false
	if managers.player:get_player_rule("no_run") then
		return
	end
	if not self._unit:movement():is_above_stamina_threshold() then
		return
	end
	if (not self._state_data.shake_player_start_running or not self._ext_camera:shaker():is_playing(self._state_data.shake_player_start_running)) and managers.user:get_setting("use_headbob") then
		self._state_data.shake_player_start_running = self._ext_camera:play_shaker("player_start_running", 0.75)
	end
	self:set_running(true)
	self._end_running_expire_t = nil
	self._start_running_t = t
	self._play_stop_running_anim = nil
	if not self:_is_reloading() or not self.RUN_AND_RELOAD then
		if not self._equipped_unit:base():run_and_shoot_allowed() then
			self._ext_camera:play_redirect(self:get_animation("start_running"))
		else
			self._ext_camera:play_redirect(self:get_animation("start_running"))
		end
	end
	if not self.RUN_AND_RELOAD then
		self:_interupt_action_reload(t)
	end
	self:_interupt_action_steelsight(t)
	self:_interupt_action_ducking(t)
end

function PlayerStandard:_end_action_running(t)
	if not self._end_running_expire_t then
		local speed_multiplier = self._equipped_unit:base():exit_run_speed_multiplier()
		self._end_running_expire_t = t + 0.4 / speed_multiplier
		local stop_running = not self.RUN_AND_RELOAD or not self:_is_reloading()

		if stop_running then
			self._ext_camera:play_redirect(self:get_animation("stop_running"), speed_multiplier)
		end
	end
end